import java.awt.event.*;
class KlickEmpfaenger implements ActionListener{
  private Datenbanktest dt;
  DatabaseConnector db1, db2;     
  List<Leser> listeVielleser;
  List<AG> agListe;
  Leser neuLeser;
  
  public KlickEmpfaenger(Datenbanktest d){
    dt=d;
    db1=new DatabaseConnector("127.0.0.1", 3306,"./lib/bib.db", "", "");     
    db2=new DatabaseConnector("127.0.0.1", 3306,"./lib/AGVerwaltung.db", "", "");
  }
  
  public void beenden(){
    db1.close();
    db2.close();
  }
  
  public List<Leser> ermittleListeVielleser(){
    List<Leser> li; 
    db1.executeStatement("SELECT Nachname, Vorname, Klasse, Anzahl From Leser, (Select * FROM (SELECT benutzer_id AS ID, COUNT(ausleih_id) AS Anzahl FROM Ausleihe GROUP By benutzer_id )) WHERE benutzer_id=ID AND Anzahl>8 ORDER By Anzahl DESC");
    QueryResult q=db1.getCurrentQueryResult();
    String[][] daten=q.getData();
    String f=db1.getErrorMessage();
    dt.setAnzeige(f);
    li=new List<Leser>();
    for(int i=0; i<q.getRowCount();i++){
      neuLeser=new Leser(daten[i][0],daten[i][1], daten[i][2],daten[i][3]);
      li.append(neuLeser);
    }
    return li;
  }
  
  public List<AG> anzahlenLeserInAGUndLeserListe(List<Leser> li){
    List<AG> agLi;
    agLi=new List<AG>();      
    db2.executeStatement("SELECT Nachname, Vorname, Klasse, AGName FROM Mitglied, besucht WHERE Mitglied.SchuelerNr=besucht.SchuelerNr" );
    QueryResult q2=db2.getCurrentQueryResult();
    String[][] daten=q2.getData();
    String f=db2.getErrorMessage();
    dt.setAnzeige(f);
    String aus="";
    for(int i=0; i<q2.getRowCount();i++){
      li.toFirst();
      while (li.hasAccess()&&(!li.getContent().nachname().equals(daten[i][0])||!li.getContent().vorname().equals(daten[i][1])||!li.getContent().klasse().equals(daten[i][2]))) { 
        li.next();
      } // end of while
      if (li.hasAccess()) {              
        agLi.toFirst();
        while (agLi.hasAccess()&& !agLi.getContent().name().equals(daten[i][3])) { 
          agLi.next();
        } // end of while
        if (agLi.hasAccess()) {
          agLi.getContent().erhoehe();               
        } // end of if
        else{
          AG ag=new AG(daten[i][3]);
          ag.erhoehe();
          agLi.append(ag);                    
        }
        
      } // end of if
    }  
    return agLi;
  }
  
  public void ausgabe(List<AG> agLi){
    String aus="";         
    agLi.toFirst();
    while (agLi.hasAccess()) { 
      aus=aus+ agLi.getContent().name()+" "+agLi.getContent().anzahlVielleser(); 
      aus=aus+"\n";
      agLi.next();
    } // end of while           
    dt.setAnzeige(aus);
  }
  
  public void actionPerformed(ActionEvent e) {
    if(e.getActionCommand().equals("Ende")){
      beenden();
    }          
    if (e.getActionCommand().equals("Liste ausgeben")){
      listeVielleser=ermittleListeVielleser();
      agListe=anzahlenLeserInAGUndLeserListe(listeVielleser);
      ausgabe(agListe);         
    }
  }
}
